#!/bin/bash
#removes already-past shows, as of an hour ago
####
WEB_DIR=/var/www/html/tv
BIN_DIR=/usr/bin
####

TODAY=$(date +%j) 
GREP_FROM=$(date --date="1 hour ago")
echo "Copying to temp file..."
cp -f ${WEB_DIR}/tv.xml ${WEB_DIR}/tvtemp.xml
echo "Applying grep to temp file..." 
echo "Keeping shows on after \"$GREP_FROM\"..."
${BIN_DIR}/tv_grep --on-after "${GREP_FROM}" --output ${WEB_DIR}/tvgrep.xml ${WEB_DIR}/tvtemp.xml
echo "Copying grep xml to tv.xml..."
cp -f ${WEB_DIR}/tvgrep.xml ${WEB_DIR}/tv.xml
echo "Removing temp file..."
rm -f ${WEB_DIR}/tvtemp.xml
echo "Done."
exit 0
