<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method='html' version='1.0' encoding='UTF-8' indent='yes'/>

<xsl:param name="DisplayLength" select="4"/>

<xsl:param name="CurrentYear"/>
<xsl:param name="CurrentMonth"/>
<xsl:param name="CurrentDay"/>
<xsl:param name="CurrentHour"/>

<xsl:param name="StopYear"/>
<xsl:param name="StopMonth"/>
<xsl:param name="StopDay"/>
<xsl:param name="StopHour"/>

<xsl:param name="PrevYear"/>
<xsl:param name="PrevMonth"/>
<xsl:param name="PrevDay"/>
<xsl:param name="PrevHour"/>

<xsl:param name="IMDBLinks" select="1"/>
<xsl:param name="Popups" select="1"/>
	<xsl:param name="DescriptionPopups" select="1"/> <!-- Moot if Popups is false -->
	<xsl:param name="ChannelPopups" select="1"/> <!-- Moot if Popups is false -->
<xsl:param name="Categories" select="1"/>

<xsl:variable name="programmes" select="/tv/programme"/>

<xsl:template match="/">
<div class="xsldiv">
<xsl:variable name="ExtendLeftText">&lt;&lt;</xsl:variable>
<xsl:variable name="ExtendRightText">&gt;&gt;</xsl:variable>

<xsl:variable name="StartDisplayCode" select="number($CurrentHour)*60" /> <!-- These are for rendering the table -->
<xsl:variable name="StopDisplayCode" select="(number($CurrentHour)+number($DisplayLength))*60" />

<xsl:variable name="StartTimeString" select="number(concat($CurrentYear, format-number($CurrentMonth,'00'), format-number($CurrentDay,'00'), format-number($CurrentHour,'00'), '00'))" /> <!-- These are for selecting the appropriate programmes -->
<xsl:variable name="StopTimeString" select="number(concat($StopYear, format-number($StopMonth,'00'), format-number($StopDay,'00'), format-number($StopHour,'00'), '00'))" /> <!-- These are for selecting the appropriate programmes -->
<table>
    <tr class="timebar">
	<th class="topleftcorner">
		<xsl:attribute name="onclick">
			<xsl:value-of select="concat('Init','(',$DisplayLength,',',$PrevHour,',',$PrevDay,',',$PrevMonth,',',$PrevYear,')')" />
		</xsl:attribute>
		Earlier
	</th>
		<xsl:call-template name="for.loop">
			<xsl:with-param name="i"><xsl:value-of select="$CurrentHour"/></xsl:with-param>
			<xsl:with-param name="count"><xsl:value-of select="$DisplayLength + $CurrentHour - 1"/></xsl:with-param>
		</xsl:call-template>
	<th class="toprightcorner">
		<xsl:attribute name="onclick">
			<xsl:value-of select="concat('Init','(',$DisplayLength,',',$StopHour,',',$StopDay,',',$StopMonth,',',$StopYear,')')" />
		</xsl:attribute>
		Later
	</th>
    </tr>
    <xsl:for-each select="/tv/channel">
    <xsl:sort select="display-name[3]" data-type="number"/>

			<xsl:variable name="iconname">
    				<xsl:call-template name="filename">
					<xsl:with-param name="x" select="icon/@src"/>
				</xsl:call-template>
			</xsl:variable>

	<tr>
		<xsl:choose>
			<xsl:when test="(position() mod 2 = 1)">
				<xsl:attribute name="class">
					oddrow
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="class">
					evenrow
				</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<th class="channel">
			<xsl:if test="$Popups and $ChannelPopups">
				<xsl:attribute name="title">
					<xsl:text>header=[</xsl:text>
					<xsl:text>&lt;img src="</xsl:text>
					<xsl:value-of select="concat('icons/',$iconname)"/>
					<xsl:text>" alt="" class="popupimage"/></xsl:text>
					<xsl:value-of select="display-name[5]" />
					<xsl:text>] body=[</xsl:text>
					<xsl:value-of select="display-name[7]"/>
					<xsl:text>] cssheader=[popupheader] cssbody=[popupbody]</xsl:text>
				</xsl:attribute>
			</xsl:if>
		<table class="leftchanneltable"><tr><td class="leftlogocell"><img><xsl:attribute name="src"><xsl:value-of select="concat('icons/',$iconname)"/></xsl:attribute><xsl:attribute name="class">channelimage</xsl:attribute></img></td><td class="leftnumbercell"><xsl:value-of select="display-name[3]"/></td><td class="middlecell"><span class="leftnumber"><xsl:value-of select="display-name[3]"/></span><br class="leftchannelbr" /><span class="leftnbsp">&#160;</span><span class="channelname"><xsl:value-of select="normalize-space(substring-after(display-name[1],display-name[3]))"/></span><br class="rightchannelbr" /><span class="rightnbsp">&#160;</span><span class="rightnumber"><xsl:value-of select="display-name[3]"/></span></td><td class="rightnumbercell"><xsl:value-of select="display-name[3]"/></td><td class="rightlogocell"><img><xsl:attribute name="src"><xsl:value-of select="concat('icons/',$iconname)"/></xsl:attribute><xsl:attribute name="class">channelimage</xsl:attribute></img></td></tr></table>
		</th>
		<xsl:variable name="theseprogrammes" select="$programmes[@channel=current()/@id and ((substring(@stop,1,12) &gt; $StartTimeString and substring(@stop,1,12) &lt;= $StopTimeString) or (substring(@start,1,12) &gt;= $StartTimeString and substring(@start,1,12) &lt; $StopTimeString) or (substring(@start,1,12) &lt;= $StartTimeString and substring(@stop,1,12) &gt;= $StopTimeString))]"/>
		<xsl:for-each select="$theseprogrammes">                                           <!--Program Stop Time is after Display Start   and Program Stop Time is before Display End......or...Program Start Time is after Display Start and Program Start Time is before Display End........or  Program Start Time is before Display Start and Program Stop Time is after Display End. -->
		<xsl:sort select="@start"/>
		<xsl:variable name="StartTime">
			<xsl:choose>
				<xsl:when test="number(substring($StartTimeString,1,8)) &lt; number(substring(@start,1,8))">  <!--it must be starting tomorrow ... Add the number of minutes in a day. -->
					<xsl:value-of select="(number((number(substring(@start,9,2))*60)+number(substring(@start,11,2)))) + 1440"/>
				</xsl:when>
				<xsl:when test="number(substring($StartTimeString,1,8)) &gt; number(substring(@start,1,8))">  <!--it have started yesterday ... Subtract the number of minutes in a day. -->
					<xsl:value-of select="(number((number(substring(@start,9,2))*60)+number(substring(@start,11,2)))) - 1440"/>
				</xsl:when>
				<xsl:otherwise> <!--otherwise it must be starting tomorrow ... Add the number of minutes in a day. -->
					<xsl:value-of select="number((number(substring(@start,9,2))*60)+number(substring(@start,11,2)))"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="Length">
			<xsl:choose>
				<xsl:when test="((number(substring(@stop,9,2))*60)+number(substring(@stop,11,2))) > ((number(substring(@start,9,2))*60)+number(substring(@start,11,2)))">
					<xsl:value-of select="(((number(substring(@stop,9,2))*60)+number(substring(@stop,11,2)))-((number(substring(@start,9,2))*60)+number(substring(@start,11,2))))"/>
				</xsl:when>
				<xsl:otherwise> <!--otherwise it must be concluding tomorrow, so the result will be negative. Add the number of minutes in a day. -->
					<xsl:value-of select="(((number(substring(@stop,9,2))*60)+number(substring(@stop,11,2)))-((number(substring(@start,9,2))*60)+number(substring(@start,11,2)))) + 1440"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="StopTime" select="$StartTime+$Length"/>
		<xsl:if test="position()=1 and number($StartTime) &gt; number($StartDisplayCode)"><td class="empty" colspan="{number($StartTime)-number($StartDisplayCode)}"></td></xsl:if>
		<td>
		<xsl:choose>
			<xsl:when test="number($StartTime) &gt;= number($StartDisplayCode) and $StopTime &lt;= $StopDisplayCode">
				<!-- Program starts during and concludes during display window. Putting first since most likely.-->
				<xsl:attribute name="colspan"><xsl:value-of select="$Length"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="number($StartTime) &lt; number($StartDisplayCode) and $StopTime &lt;= $StopDisplayCode">
				<!-- Program starts before and concludes during display window-->
				<xsl:attribute name="colspan"><xsl:value-of select="(($Length - ($StartDisplayCode - $StartTime)))"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$StartTime &gt;= $StartDisplayCode and $StopTime &gt; $StopDisplayCode">
				<!-- Program starts during and concludes after display window -->
				<xsl:attribute name="colspan"><xsl:value-of select="(($Length - ($StopTime - $StopDisplayCode)))"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$StartTime &lt; $StartDisplayCode and $StopTime &gt; $StopDisplayCode">
				<!-- Program starts before and concludes after display window. Least likely. -->
				<xsl:attribute name="colspan"><xsl:value-of select="(($Length - ($StopTime - $StopDisplayCode) - ($StartDisplayCode - $StartTime)))"/></xsl:attribute>
			</xsl:when>
			</xsl:choose>
					<xsl:if test="$Categories">
						<xsl:attribute name="class">
							<xsl:for-each select="category">
								<xsl:value-of select="translate(.,' ','_')" /><xsl:text> </xsl:text>
							</xsl:for-each>
							<xsl:if test="$Length &gt; 69">
								Longshow
							</xsl:if>
						</xsl:attribute>
					</xsl:if>
					<xsl:if test="$Popups and $DescriptionPopups">
						<xsl:attribute name="title">
							<xsl:text>header=[</xsl:text>
							<xsl:value-of select="title" />
							<xsl:text>] body=[</xsl:text>
							<xsl:value-of select="number(substring(@start,9,2))"/>:<xsl:value-of select="substring(@start,11,2)"/>-<xsl:value-of select="number(substring(@stop,9,2))"/>:<xsl:value-of select="substring(@stop,11,2)"/> &lt;i&gt;<xsl:value-of select="rating/value" />&lt;/i&gt;
							&lt;hr /&gt;
							<xsl:if test="sub-title">
								&lt;span class="subtitle"&gt;
								<xsl:value-of select="sub-title"/>
								&lt;/span&gt;&lt;br /&gt;
							</xsl:if>
							<xsl:value-of select="desc" />
							<xsl:if test="date">
								<xsl:choose>
									<xsl:when test="string-length(date) = 8">
										<xsl:text>&#160;</xsl:text><xsl:value-of select="concat(substring(date,5,2),'/',substring(date,7,2),'/',substring(date,1,4))" />
									</xsl:when>
									<xsl:when test="string-length(date) = 4">
										<xsl:text>&#160;</xsl:text><xsl:value-of select="date" />
									</xsl:when>
								</xsl:choose>
							</xsl:if>
							<xsl:text>] cssheader=[popupheader] cssbody=[popupbody]</xsl:text>
						</xsl:attribute>
					</xsl:if>
					<xsl:if test="$IMDBLinks">
						<xsl:attribute name="onclick">
							<xsl:text>window.open('http://www.imdb.com/find?q=</xsl:text>						
								<xsl:call-template name="replace">
								<xsl:with-param name="string">
									<xsl:call-template name="replace">
									<xsl:with-param name="string">
										<xsl:call-template name="replace">
											<xsl:with-param name="string">
												<xsl:call-template name="fixquotes">
												<xsl:with-param name="string" select="translate(title,' ','+')" />
												</xsl:call-template>
											</xsl:with-param>
											<xsl:with-param name="pattern" select="'&amp;'"/>
											<xsl:with-param name="replacement" select="'%26'"/>
										</xsl:call-template>
									</xsl:with-param>
									<xsl:with-param name="pattern" select="'='"/>
									<xsl:with-param name="replacement" select="'%3d'"/>
									</xsl:call-template>
								</xsl:with-param>
								<xsl:with-param name="pattern" select="'?'"/>
								<xsl:with-param name="replacement" select="'%3f'"/>
								</xsl:call-template>							
							<xsl:text>')</xsl:text>
						</xsl:attribute>
					</xsl:if>
		<xsl:choose>
			<xsl:when test="number($StartTime) &gt;= number($StartDisplayCode) and $StopTime &lt;= $StopDisplayCode">
				<!-- Program starts during and concludes during display window. Putting first since most likely.-->
						<table class="internal"><tr><td class="program"><xsl:value-of select="title" /></td></tr></table>
			</xsl:when>
			<xsl:when test="number($StartTime) &lt; number($StartDisplayCode) and $StopTime &lt;= $StopDisplayCode">
				<!-- Program starts before and concludes during display window-->
						<table class="internal"><tr><td class="extendleft"><xsl:value-of select="$ExtendLeftText" /></td><td class="program"><xsl:value-of select="title" /></td></tr></table>
			</xsl:when>
			<xsl:when test="$StartTime &gt;= $StartDisplayCode and $StopTime &gt; $StopDisplayCode">
				<!-- Program starts during and concludes after display window -->
						<table class="internal"><tr><td class="program"><xsl:value-of select="title" /></td><td class="extendright"><xsl:value-of select="$ExtendRightText" /></td></tr></table>
			</xsl:when>
			<xsl:when test="$StartTime &lt; $StartDisplayCode and $StopTime &gt; $StopDisplayCode">
				<!-- Program starts before and concludes after display window. Least likely. -->
						<table class="internal"><tr><td class="extendleft"><xsl:value-of select="$ExtendLeftText" /></td><td class="program"><xsl:value-of select="title" /></td><td class="extendright"><xsl:value-of select="$ExtendRightText" /></td></tr></table>
			</xsl:when>
		</xsl:choose>
		</td>
		<xsl:if test="position()=last() and number($StopTime) &lt; number($StopDisplayCode)"><td class="empty" colspan="{number($StopDisplayCode)-number($StopTime)}"></td></xsl:if>
		</xsl:for-each>
		<!--check for a row with no programs and fill it in with an empty row-->
		<xsl:if test="not($theseprogrammes)"><td class="empty" colspan="{number($StopDisplayCode)-number($StartDisplayCode)}"></td></xsl:if>
		<th class="channel">
			<xsl:if test="$Popups and $ChannelPopups">
				<xsl:attribute name="title">
					<xsl:text>header=[</xsl:text>
					<xsl:text>&lt;img src="</xsl:text>
					<xsl:value-of select="concat('icons/',$iconname)"/>
					<xsl:text>" alt="" class="popupimage"/></xsl:text>
					<xsl:value-of select="display-name[5]" />
					<xsl:text>] body=[</xsl:text>
					<xsl:value-of select="display-name[7]"/>
					<xsl:text>] cssheader=[popupheader] cssbody=[popupbody]</xsl:text>
				</xsl:attribute>
			</xsl:if>
		<table class="rightchanneltable"><tr><td class="leftlogocell"><img><xsl:attribute name="src"><xsl:value-of select="concat('icons/',$iconname)"/></xsl:attribute><xsl:attribute name="class">channelimage</xsl:attribute></img></td><td class="leftnumbercell"><xsl:value-of select="display-name[3]"/></td><td class="middlecell"><span class="leftnumber"><xsl:value-of select="display-name[3]"/></span><br class="leftchannelbr" /><span class="leftnbsp">&#160;</span><span class="channelname"><xsl:value-of select="normalize-space(substring-after(display-name[1],display-name[3]))"/></span><br class="rightchannelbr" /><span class="rightnbsp">&#160;</span><span class="rightnumber"><xsl:value-of select="display-name[3]"/></span></td><td class="rightnumbercell"><xsl:value-of select="display-name[3]"/></td><td class="rightlogocell"><img><xsl:attribute name="src"><xsl:value-of select="concat('icons/',$iconname)"/></xsl:attribute><xsl:attribute name="class">channelimage</xsl:attribute></img></td></tr></table>
		</th></tr>
    </xsl:for-each>
</table>
<script>if(self.scanDOM)scanDOM(document)</script> <!--This refreshes the dhtml popups so they work when the innerHTML is reloaded. It only seems to work in Firefox.-->
</div>
</xsl:template>

<xsl:template name="for.loop">
<!--
This template from http://www.bigbold.com/snippets/tag/hello
-->
   <xsl:param name="i" />
   <xsl:param name="count" />

   <!--begin_: Line_by_Line_Output -->
   <xsl:if test="$i &lt;= $count">
	<xsl:choose>
		<xsl:when test="$i &gt; 23">
			<th colspan="30" class="time"><xsl:value-of select="$i - 24" />:00</th><th colspan="30" class="time"><xsl:value-of select="$i - 24" />:30</th>
		</xsl:when>
		<xsl:otherwise>
			<th colspan="30" class="time"><xsl:value-of select="$i" />:00</th><th colspan="30" class="time"><xsl:value-of select="$i" />:30</th>
		</xsl:otherwise>
	</xsl:choose>
   </xsl:if>

   <!--begin_: RepeatTheLoopUntilFinished-->
   <xsl:if test="$i &lt;= $count">
      <xsl:call-template name="for.loop">
          <xsl:with-param name="i">
              <xsl:value-of select="$i + 1"/>
          </xsl:with-param>
          <xsl:with-param name="count">
              <xsl:value-of select="$count"/>
          </xsl:with-param>
      </xsl:call-template>
   </xsl:if>

  </xsl:template>

<xsl:template name="filename">
<!--
This template from http://www.maya.com/local/doc/xslt/FAQ/html_format/xsl/sect2/N7240.html
-->
<xsl:param name="x"/>
<xsl:choose>
<xsl:when test="contains($x,'/')">
  <xsl:call-template name="filename">
    <xsl:with-param name="x" select="substring-after($x,'/')"/>
  </xsl:call-template>
</xsl:when>
<xsl:otherwise>
  <xsl:value-of select="$x"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="replace"> 
 <!--
This template by Greg Faron on http://www.biglist.com/lists/xsl-list/archives/200211/msg00335.html
-->
<xsl:param name="string" select="''"/>
<xsl:param name="pattern" select="''"/>
<xsl:param name="replacement" select="''"/>
<xsl:choose>
<xsl:when test="$pattern != '' and $string != '' and contains($string, $pattern)">
<xsl:value-of select="substring-before($string, $pattern)"/>
<xsl:copy-of select="$replacement"/>
<xsl:call-template name="replace">
<xsl:with-param name="string" select="substring-after($string, $pattern)"/>
<xsl:with-param name="pattern" select="$pattern"/>
<xsl:with-param name="replacement" select="$replacement"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$string"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="fixquotes">
   <xsl:param name="string"/>
    <xsl:choose>
      <xsl:when test="contains($string, &quot;'&quot;)">
        <xsl:value-of select="substring-before($string, &quot;'&quot;)"/>
        <xsl:text>\'</xsl:text>
        <xsl:call-template name="fixquotes">
          <xsl:with-param name="string"
            select="substring-after($string, &quot;'&quot;)"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$string"/>
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>